<?php

namespace App\Http\Controllers;

use App\Models\General;
use App\Models\Notification;
use App\Models\User;
use Illuminate\Support\Facades\Session;


class DepositController extends Controller
{
    public function userDataUpdate($data)
    {
        if($data->status==0){
            $data['status'] = 1;
            $data->update();
            $user = User::find($data->user_id);
            createTransaction("Deposit via " . $data->gateway->name,$data->amount,$user->balance,$user->balance + $data->amount,1);

            $user['balance'] = $user->balance + $data->amount;
            $user->update();
            $gnl = General::first();
            $shortCodes = [
                'trx' => $data->trx,
                'amount' => $data->amount,
                'charge' => $data->charge,
                'rate' => $data->gateway->rate,
                'currency' => $gnl->currency,
                'method_name' => $data->gateway->name,
                'method_currency' => $gnl->currency,
            ];
            @send_email($user, 'DEPOSIT_COMPLETE' , $shortCodes);
            Session::flash('success', 'Deposited ' . $data->amount . ' ' . $gnl->currency . ' successfully');

            $adminNotification = new Notification();
            $adminNotification->user_id = $user->id;
            $adminNotification->title = 'Deposit Successful via '.$data->gateway->name;
            $adminNotification->click_url = urlPath('admin.deposit.depositLog');
            $adminNotification->save();

            return redirect()->route('users.showDepositMethods');
        }
    }
}

?>