@extends($theme.'frontend.layouts.master')
@section('title',__('Support Reply'))
@section('content')

<div class="check-profit-area pb-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <form method="POST" action="{{route('store.customer.reply', $ticket_object->ticket)}}" accept-charset="UTF-8" class="form-horizontal form-bordered">
                    @csrf
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h5 class="h3 mb-0">#{{$ticket_object->ticket}} - {{$ticket_object->subject}}</h5>
                        </div>
                        <div class="col-md-6 text-right pt-2">
                            @if($ticket_object->status == 1)
                            <button class="btn btn-warning btn-sm pull-end"> {{__('Opened')}}</button>
                            @elseif($ticket_object->status == 2)
                            <button type="button" class="btn btn-success btn-sm pull-end">  {{__('Answered')}} </button>
                            @elseif($ticket_object->status == 3)
                            <button type="button" class="btn btn-info btn-sm pull-end"> {{__('Customer Reply')}} </button>
                            @elseif($ticket_object->status == 9)
                            <button type="button" class="btn btn-danger btn-sm pull-end">  {{__('Closed')}} </button>
                            @endif
                            <a href="{{route('ticket.close', $ticket_object->ticket)}}" class="btn btn-danger btn-sm pull-end make-close-support">{{__('Make to Close')}}</a>
                        </div>
                    </div>
                    <div class="blog-comment">
                        <ul class="comment-list comment-list-cus mt-lg-4 pt-2 mt-4">
                            @foreach($ticket_data as $data)
                            <div class="card mb-2">
                                <div class="card-body">
                                    <li class="comment">
                                        <article class="comment-body comment-body-cus">
                                            <footer class="comment-meta">
                                                <div class="comment-author vcard">
                                                    <b>
                                                        @if($data->type == 1)
                                                            {{$ticket_object->user_member->name}}
                                                        @elseif($data->type == 0)
                                                            {{__('Admin')}}
                                                        @endif
                                                    </b>          
                                                </div>
                                                <div class="comment-metadata">
                                                    <small>{{$data->updated_at->format('d M, Y - h:i A') }}</small>                 
                                                </div>
                                            </footer>
                                            <div class="comment-content">
                                                <p>{!! $data->comment !!}</p>
                                            </div>          
                                        </article>
                                    </li>

                                </div>
                            </div>
                            @endforeach
                        </ul>
                    </div> 
                    
                        <div class="mb-3">
                            <h4>{{__('Leave a Reply')}}</h4>
                        </div>

                        <div class="form-group">
                            <textarea name="comment" placeholder="Details..." class="form-control"></textarea>
                        </div>
                        <button type="submit" class="btn btn-success btn-block">{{__('Post')}}</button>

                        {{-- <div class="row">
                            <div class="col-12">
                                <div class="single-input-inner style-bg">
                                    <textarea placeholder="Message"  name="comment"></textarea>
                                </div>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-base border-radius-5">{{__('Post Comment')}}</button>
                            </div>
                        </div> --}}
                    </form> 
                </div>
            </div>
        </div>
    </div>
</div>

@endsection