@extends($theme.'frontend.layouts.master')
@section('title',__('Invest History'))
@section('content')
<div class="transaction-area pd-top-90 pd-bottom-120">
    <div class="container">
        <div class="table-responsive">
            <table class="table transaction-table style-2">
                <thead>
                    <tr>
                        <th> {{__('Package')}} </th>
                        <th> {{__('Type')}} </th>
                        <th> {{__('Invest Amount')}} </th>
                        <th> {{__('Payable')}} </th>
                        <th> {{__('Already Return')}} </th>
                        <th> {{__('Next Return Time')}} </th>
                        <th> {{__('Status')}} </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($plans as $data)
                    <tr>
                        <td>{{__($data->plan_name)}}</td>
                        <td>
                            @switch($data->get_period)
                                @case(1)
                                {{__('Hourly')}}
                                @break
                                @case(24)
                                {{__('Daily')}}   @break
                                @case(168)
                                {{__('Weekly')}}   @break
                                @case(720)
                                {{__('Monthly')}}   @break
                                @case(2880)
                                {{__('Quarterly')}}   @break
                                @case(8640)
                                {{__('Yearly')}}   @break
                            @endswitch
                        </td>
                        <td>{{$data->invest_amount}}  {{$general->currency}}</td>
                        <td>{{$data->get_percent}}%/{{is_null($data->get_action) ? 'Lifetime': $data->get_action.' Times'}}  </td>
                        <td>{{$data->took_action}} {{__('TIMES')}}</td>
                        <td>{{date('d/m/y  h:i A',strtotime($data->next_time))}}</td>
                        <td>
                            @if($data->status == 0)
                                <span class="badge bg-primary">{{__('Continue')}}</span>
                            @else
                                <span class="badge bg-success">{{__('Complete')}}</span>
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="row">
                <div class="col-md-12 text-center">
                    {{$plans->links()}}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
