@extends($theme.'frontend.layouts.master')
@section('title', __('Payment Methods'))
@section('content')
<div class="payment-area bg-navy-2 pd-top-90 pd-bottom-90">
    <div class="container">
        <div class="row justify-content-center">
            @foreach($gateways as $gate)
            <div class="col-lg-3 col-md-6 align-self-center">
                <div class="single-payment-wrap bg-black-2 withdraw-card-area">
                    <div class="thumb">
                        <img src="{{asset('public/images/withdraw_methods')}}/{{$gate->image}}" alt="img">
                    </div>
                    <div class="details">
                        <h4>{{__($gate->name)}}</h4>
                        <a class="read-more-arrow" href="#depositModal{{$gate->id}}" data-bs-toggle="modal"><i class="fa fa-angle-right"></i></a>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="depositModal{{$gate->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title text-dark" id="exampleModalLabel">{{__('Withdraw via')}} {{__($gate->name)}}</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="{{route('withdraw.preview.user')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body">
                            <p class="text-danger">{{__('Charge for withdraw Amount')}}: {{$gate->chargefx}} {{$general->currency}}</p>
                            <p class="text-dark">{{__('Percentage Charge')}}: {{$gate->chargepc}} %</p>
                            <p class="text-danger">{{__('Processing Days (At last)')}} : {{$gate->processing_day}} {{__('Days')}}</p>
                            <p class="text-success"> {{__('Minimum')}} {{$gate->min_amo}}{{$general->currency}} & {{__('Maximum')}} {{$gate->max_amo}} {{$general->currency}}</p>
                            <hr/>
                            <input type="hidden" name="gateway" value="{{$gate->id}}">
                            <div class="form-group">
                                <div class="input-group">
                                    <input type="text" name="amount" class="form-control" id="amount" placeholder="{{__('AMOUNT YOU WANT TO WITHDRAW')}}" required>
                                    <div class="input-group-append">
                                        <span class="input-group-text">{{$general->currency}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-success">{{__('Preview')}}</button>
                            <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('Close')}}</button>
                        </div>
                    </form>
                  </div>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endsection
